// interIterator.java
// demonstruje dziaanie iteratorw
// uruchomienie programu: C>java InterIterApp
import java.io.*;                 // operacje wejcia-wyjcia
////////////////////////////////////////////////////////////////
class Link
   {
   public long dData;             // dane
   public Link next;              // nastpny element
// -------------------------------------------------------------
   public Link(long dd)           // konstruktor
      { dData = dd; }
// -------------------------------------------------------------
   public void displayLink()      // wypisanie zawartoci
      { System.out.print(dData + " "); }
   }  // koniec klasy Link
////////////////////////////////////////////////////////////////
class LinkList
   {
   private Link first;            // referencja do pierwszego elementu

// -------------------------------------------------------------
   public LinkList()              // konstruktor
      { first = null; }           // na razie lista jest pusta
// -------------------------------------------------------------
   public Link getFirst()         // pobieramy referencj do pierwszego elementu
      { return first; }
// -------------------------------------------------------------
   public void setFirst(Link f)   // ustawiamy referencj do pierwszego elementu
      { first = f; }
// -------------------------------------------------------------
   public boolean isEmpty()       // zwraca true, jeeli lista jest pusta
      { return first==null; }
// -------------------------------------------------------------
   public ListIterator getIterator()  // zwraca iterator...
      {
      return new ListIterator(this);  // ...zainicjalizowany danymi...
      }                               //    ...tej listy
// -------------------------------------------------------------
   public void displayList()
      {
      Link current = first;       // rozpoczynamy na pocztku
      while(current != null)      // dopki nie koniec listy...
         {
         current.displayLink();   // ...wypisujemy dane...
         current = current.next;  // ...i przechodzimy do nastpnego
         }
      System.out.println("");
      }
// -------------------------------------------------------------
   }  // koniec klasy LinkList
////////////////////////////////////////////////////////////////
class ListIterator
   {
   private Link current;          // aktualny element
   private Link previous;         // poprzedni element
   private LinkList ourList;      // lista, na ktrej operuje iterator
//--------------------------------------------------------------
   public ListIterator(LinkList list) // konstruktor
      {
      ourList = list;
      reset();
      }
//--------------------------------------------------------------
   public void reset()            // powrt na pocztek listy
      {
      current = ourList.getFirst();
      previous = null;
      }
//--------------------------------------------------------------
   public boolean atEnd()         // zwraca true, jeeli jestemy na kocu listy
      { return (current.next==null); }
//--------------------------------------------------------------
   public void nextLink()         // przejcie do nastpnego elementu
      {
      previous = current;
      current = current.next;
      }
//--------------------------------------------------------------
   public Link getCurrent()       // pobranie aktualnego elementu
      { return current; }
//--------------------------------------------------------------
   public void insertAfter(long dd)     // wstawienie po aktualnym elemencie
      {                      
      Link newLink = new Link(dd);

      if( ourList.isEmpty() )     // jeeli lista jest pusta
         {
         ourList.setFirst(newLink);
         current = newLink;
         }
      else                        // jeeli nie jest pusta
         {
         newLink.next = current.next;
         current.next = newLink;
         nextLink();              // przechodzimy do nowo wstawionego elementu
         }
      }
//--------------------------------------------------------------
   public void insertBefore(long dd)    // wstawienie przed aktualnym elementem
      {                       
      Link newLink = new Link(dd);

      if(previous == null)        // jeeli pocztek listy
         {                        // (albo lista pusta)
         newLink.next = ourList.getFirst();
         ourList.setFirst(newLink);
         reset();
         }
      else                        // jeeli nie pocztek
         {
         newLink.next = previous.next;
         previous.next = newLink;
         current = newLink;
         }
      }
//--------------------------------------------------------------
   public long deleteCurrent()    // usunicie aktualnego elementu
      {
      long value = current.dData;
      if(previous == null)        // jeeli pocztek listy
         {
         ourList.setFirst(current.next);
         reset();
         }
      else                        // jeeli nie pocztek
         {
         previous.next = current.next;
         if( atEnd() )
            reset();
         else
            current = current.next;
         }
      return value;
      }
//--------------------------------------------------------------
   }  // koniec klasy ListIterator
////////////////////////////////////////////////////////////////
class InterIterApp
   {
   public static void main(String[] args) throws IOException
      {
      LinkList theList = new LinkList();           // nowa lista
      ListIterator iter1 = theList.getIterator();  // nowy iterator
      long value;

      iter1.insertAfter(20);             // wstawiamy elementy
      iter1.insertAfter(40);
      iter1.insertAfter(80);
      iter1.insertBefore(60);

      while(true)
         {
         System.out.print("Wybierz liter: [s] poka, [r] pocztek, [n] nastpny, ");
         System.out.print("[g] pobierz, [b] wstaw przed, [a] wstaw po, [d] usu: ");
         System.out.flush();
         int choice = getChar();         // odczytujemy wybr uytkownika
         switch(choice)
            {
            case 's':                    // wypisanie elementw listy
               if( !theList.isEmpty() )
                  theList.displayList();
               else
                  System.out.println("Lista jest pusta");
               break;
            case 'r':                    // powrt na pocztek listy
               iter1.reset();
               break;
            case 'n':                    // przejcie do nastpnego elementu
               if( !theList.isEmpty() && !iter1.atEnd() )
                  iter1.nextLink();
               else
                  System.out.println("Nie ma nastpnego elementu");
               break;
            case 'g':                    // pobranie aktualnego elementu
               if( !theList.isEmpty() )
                  {
                  value = iter1.getCurrent().dData;
                  System.out.println("Pobrano " + value);
                  }
               else
                  System.out.println("Lista jest pusta");
               break;
            case 'b':                    // wstawienie przed aktualnym elementem
               System.out.print("Podaj warto klucza: ");
               System.out.flush();
               value = getInt();
               iter1.insertBefore(value);
               break;
            case 'a':                    // wstawienie po aktualnym elemencie
               System.out.print("Podaj warto klucza: ");
               System.out.flush();
               value = getInt();
               iter1.insertAfter(value);
               break;
            case 'd':                    // usunicie aktualnego elementu
               if( !theList.isEmpty() )
                  {
                  value = iter1.deleteCurrent();
                  System.out.println("Usnito " + value);
                  }
               else
                  System.out.println("Nie mona usun");
               break;
            default:
               System.out.println("Nieprawidowy wybr");
            }  // koniec switch
         }  // koniec while
      }  // koniec main()
//--------------------------------------------------------------
   public static String getString() throws IOException
      {
      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader br = new BufferedReader(isr);
      String s = br.readLine();
      return s;
      }
//-------------------------------------------------------------
   public static char getChar() throws IOException
      {
      String s = getString();
      return s.charAt(0);
      }

//-------------------------------------------------------------
   public static int getInt() throws IOException
      {
      String s = getString();
      return Integer.parseInt(s);
      }
//-------------------------------------------------------------
   }  // koniec klasy InterIterApp
////////////////////////////////////////////////////////////////
